#{{uc_id}} 
{ 
  text-align: {{alignment}}; 
  direction: {{direction}};
  position: relative;
}

#{{uc_id}} * {
    box-sizing: border-box;
}
#{{uc_id}} a
{
  transition: 0.5s;
} 

#{{uc_id}} > ul.ue-tab-btns
{
	margin:0px;
	list-style:none;
    display:flex;
}

#{{uc_id}} > ul.ue-tab-btns li
{
	padding:0px; 
	margin:0px;
    {% if make_tabs_equal == "true" %}
       flex:1;
       text-align:center;
    {% endif %}	
}
	
#{{uc_id}} ul.ue-tab-btns li a {
	display:flex;
	text-decoration:none;
    transition:0.5s;
}
#{{uc_id}} .panel-container{
  overflow:hidden;
}
#{{uc_id}} .tab-container {
	clear:both;
	overflow:hidden;
}
#{{uc_id}} .ue_repeater_tabs_container{
  display:flex;
}
#{{uc_id}} .ue_repeater_tab_content{
  flex-grow:1;
}

#{{uc_id}} .ue_repeater_image
{
  flex-grow:0;
  flex-shrink:0;
  overflow:hidden;
}
#{{uc_id}} .ue_repeater_image img
{
  display:block;
  width:100%;
}

#{{uc_id}} .ue_repeater_link
{
  display:{{button_style}};
  text-decoration:none;
}

.uc_bold_tabs .panes{ display:none;}
.r-tabs .r-tabs-tab {
    display: block;
    margin: 0;
    list-style: none;
}

.r-tabs .r-tabs-panel {
    padding: 0;
    display: none;
}

.r-tabs .r-tabs-accordion-title {
    display: none;
}

.r-tabs .r-tabs-panel.r-tabs-state-active {
    display: block;
}
    
{% if scrollable_tabs == "true" %}

  #{{uc_id}} > ul.tabs{
     justify-content:unset;
     flex-wrap: nowrap;
     overflow-x: scroll; 
  }

  #{{uc_id}} > ul.tabs::-webkit-scrollbar{
     display: none;
  }

{% else %}

  #{{uc_id}} > ul.tabs{
      justify-content:{{tab_bar_alignment}};
      flex-wrap: wrap;
  }

{% endif %}

@media only screen and (max-width: 767px)
{
 #{{uc_id}} ul.tabs {display:flex;}
 .r-tabs .r-tabs-nav { display: none;}

    .r-tabs .r-tabs-accordion-title { 
      display: none;
    }
	.r-tabs-anchor{ 
      display:block; 
      overflow:hidden; 
    }
}

  {% if (snap_to_tabs_filter_item == "true") %}
    #{{uc_id}} .r-tabs-nav{
        scroll-snap-type: both mandatory;
    }

    #{{uc_id}} .r-tabs-nav > .r-tabs-tab{
        scroll-snap-align: start;
    }
  {% endif %}


{% if layout == "vertical" %}
	#{{uc_id}} 
    {
      display:flex;
    }

    #{{uc_id}} ul.ue-tab-btns
    {
      flex-direction:column;
      
      flex-shrink:0;
      flex-grow:0;
    }


	#{{uc_id}} .panel-container{
      flex-grow:1;
    }
{% endif %}




#{{uc_id}} .ue-meta-data
{
  
  display:flex;

  flex-wrap: wrap;
  line-height:1em;
}

{% if accordion_breakpoint == "true" %}

@media only screen and (max-width: {{responsive_breakpoint}}px){
  
 #{{uc_id}} > ul.tabs {display:none;}
 #{{uc_id}}.r-tabs .r-tabs-nav { display: none;}

 #{{uc_id}}.r-tabs .r-tabs-accordion-title { display: block;}
 #{{uc_id}} .r-tabs-anchor{ 
      display:flex;
      align-items:center;
      overflow:hidden; 
   	  justify-content: space-between;
 }
  
 #{{uc_id}} .uc-tabs-accordion-title{
     flex-grow:1;
 }
  
 #{{uc_id}} .r-tabs-accordion-title .uc-accordion-icon-collapse{
    display:none;    
 }
  
 #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-collapse{
    display:block;
 }
  
 #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-expand{
    display:none;
 }
  
 #{{uc_id}} .ue-item-content-layout{
    display:flex;
    flex-direction:column;
 }

 #{{uc_id}} .ue-item-image-wrapper{
 	width:100%;
 }

 #{{uc_id}} .uc-tabs-accordion-title{
    display:flex;
    align-items:center;
 }

 #{{uc_id}} .panel-container{
   width:100%;
 }   
  
}

{% endif %}

{% if show_increment == "true" %}
  .ue_repeater_tabs_increment{
    display:flex;
    justify-content:center;
    align-items:center;
    line-height:1;
    transition: 0.5s;
  }
{% endif %}