<?php
namespace ElementsKit\Modules\Parallax;

defined( 'ABSPATH' ) || exit;

class Init{
    private $dir;
    private $url;

    public function __construct(){

        // get current directory path
        $this->dir = dirname(__FILE__) . '/';

        // get current module's url
		$this->url = \ElementsKit::plugin_url() . 'modules/parallax/';
		
		// enqueue scripts
		add_action('wp_head', [$this, 'inline_script']);
		add_action('elementor/frontend/before_register_scripts', [$this, 'enqueue_frontend_scripts']);

		// include all necessary files
		$this->include_files();

		// calling the section parallax class
		new \Elementor\ElementsKit_Section_Effect_Controls();
		new \Elementor\ElementsKit_Widget_Effect_Controls();
	}
	
	public function include_files(){
		include $this->dir . 'section-controls.php';
		include $this->dir . 'widget-controls.php';
	}

	public function inline_script() {
		echo '<script type="text/javascript">';
		echo 'var elementskit_module_parallax_url = "' . esc_url($this->url) . '";';
		echo '</script>';
	}

	public function enqueue_frontend_scripts() {
		$assets =[
			'styles' => [
				'elementskit-parallax' => [
					'src' => $this->url . 'assets/css/style.css',
					'version' => \ElementsKit::version(),
					'dependencies' => [],
				],
			],
			'scripts' => [
				'jarallax' => [
					'src' => $this->url . 'assets/js/jarallax.js',
					'version' => \ElementsKit::version(),
					'dependencies' => [],
				],
				'elementskit-parallax-frontend' => [
					'src' => $this->url . 'assets/js/parallax-frontend.js',
					'version' => \ElementsKit::version(),
					'dependencies' => ['animejs'],
				],
				'elementskit-parallax-admin' => [
					'src' => $this->url . 'assets/js/parallax-admin.js',
					'version' => \ElementsKit::version(),
					'dependencies' => [],
				],
			],
		];

		if ( $assets ) {
			\Elementor\Plugin::$instance->assets_loader->add_assets( $assets );
		}
	}
}